/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.clientsort.client.inventory.screen;

import dev.terminalmc.clientsort.client.config.Config;
import dev.terminalmc.clientsort.client.inventory.screen.CreativeContainerScreenHelper;
import dev.terminalmc.clientsort.client.inventory.util.Scope;
import dev.terminalmc.clientsort.client.network.InteractionManager;
import dev.terminalmc.clientsort.client.util.SoundManager;
import dev.terminalmc.clientsort.mixin.client.accessor.AbstractContainerScreenAccessor;
import dev.terminalmc.clientsort.util.inject.ISlot;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.client.gui.screens.inventory.EffectRenderingInventoryScreen;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;

public class ContainerScreenHelper<T extends AbstractContainerScreen<?>> {
    protected final T screen;
    protected final InteractionManager.ClickEventFactory clickEventFactory;

    protected ContainerScreenHelper(T screen, InteractionManager.ClickEventFactory clickEventFactory) {
        this.screen = screen;
        this.clickEventFactory = clickEventFactory;
    }

    public static <T extends AbstractContainerScreen<?>> ContainerScreenHelper<T> of(T screen, InteractionManager.ClickEventFactory clickEventFactory) {
        if (screen instanceof CreativeModeInventoryScreen) {
            return new CreativeContainerScreenHelper<CreativeModeInventoryScreen>((CreativeModeInventoryScreen)screen, clickEventFactory);
        }
        return new ContainerScreenHelper<T>(screen, clickEventFactory);
    }

    public static <T extends AbstractContainerScreen<?>> ContainerScreenHelper<T> of(T screen) {
        InteractionManager.ClickEventFactory clickEventFactory = (slot, mouseButton, clickType, playSound) -> new InteractionManager.CallbackEvent(() -> {
            ((AbstractContainerScreenAccessor)screen).clientsort$slotClicked(slot, ((ISlot)slot).clientsort$getIdInContainer(), mouseButton, clickType);
            if (playSound) {
                SoundManager.play();
            }
            return InteractionManager.TICK_WAITER;
        });
        return ContainerScreenHelper.of(screen, clickEventFactory);
    }

    public InteractionManager.InteractionEvent createClickEvent(Slot slot, int button, ClickType clickType, boolean playSound) {
        return this.clickEventFactory.create(slot, button, clickType, playSound);
    }

    public boolean isHotbarSlot(Slot slot) {
        return ((ISlot)slot).clientsort$getIndexInInv() < 9;
    }

    public boolean isExtraSlot(Slot slot) {
        return ((ISlot)slot).clientsort$getIndexInInv() > 35;
    }

    public Scope getScope(Slot slot) {
        if (this.screen instanceof EffectRenderingInventoryScreen) {
            if (slot.container instanceof Inventory) {
                boolean mergeWithHotbar = false;
                if (this.isExtraSlot(slot)) {
                    switch (Config.options().extraSlotScope) {
                        case HOTBAR: {
                            mergeWithHotbar = true;
                            break;
                        }
                        case EXTRA: {
                            return Scope.PLAYER_INV_EXTRA;
                        }
                        case NONE: {
                            return Scope.INVALID;
                        }
                    }
                }
                if (mergeWithHotbar || this.isHotbarSlot(slot)) {
                    switch (Config.options().hotbarScope) {
                        case HOTBAR: {
                            return Scope.PLAYER_INV_HOTBAR;
                        }
                        case NONE: {
                            return Scope.INVALID;
                        }
                    }
                }
                return Scope.PLAYER_INV;
            }
            return Scope.PLAYER_OTHER;
        }
        if (slot.container instanceof Inventory) {
            if (this.isHotbarSlot(slot)) {
                switch (Config.options().hotbarScope) {
                    case HOTBAR: {
                        return Scope.PLAYER_INV_HOTBAR;
                    }
                    case NONE: {
                        return Scope.INVALID;
                    }
                }
            }
            return Scope.PLAYER_INV;
        }
        return Scope.CONTAINER_INV;
    }

    public void translateSlotIds(int[] slotMapping) {
    }
}

